#include <iostream>
#include <string.h>

#define MIN_BROJ_PACIJENATA 0
#define MAX_BROJ_PACIJENATA 10000

#define MIN_BROJ_KRVI       0
#define MAX_BROJ_KRVI       1000000

using namespace std;
enum Krvna_Grupa
{
    O, A, B, AB
};

struct Pacijent
{
    Krvna_Grupa grupa;
    unsigned int jedinica;
    unsigned int jedO;
    unsigned int jedA;
    unsigned int jedB;
    unsigned int jedAB;
};

int main()
{
    unsigned short int brojPacijenata;
    unsigned int brojO;
    unsigned int brojA;
    unsigned int brojB;
    unsigned int brojAB;

    string str;

    /// Uneti broj pacijenata
    getline(cin, str);
    while(true)
    {
        bool uspesno = false;

        unsigned char counter = 1;
        size_t found = -1;
        while(true)
        {
            found  = str.find(' ', found + 1);
            if(found != string::npos)
            {
                counter++;
            }
            else
            {
                break;
            }
        }

        if(counter == 1)
        {
            sscanf(str.c_str(), "%hu", &brojPacijenata);

            uspesno = (brojPacijenata >= MIN_BROJ_PACIJENATA && brojPacijenata <= MAX_BROJ_PACIJENATA) ? true : false;
        }

        if(!uspesno)
        {
            cout << "Pogresan unos, pokusaj opet: ";
            getline(cin, str);
        }
        else
        {
            break;
        }
    }

    /// Uneti broj jedinica krvi. Primer 2 0 2 2
    getline(cin, str);
    while(true)
    {
        bool uspesno = false;

        unsigned char counter = 1;
        size_t found = -1;
        while(true)
        {
            found  = str.find(' ', found + 1);
            if(found != string::npos)
            {
                counter++;
            }
            else
            {
                break;
            }
        }

        if(counter == 4)
        {
            sscanf(str.c_str(), "%u %u %u %u", &brojO, &brojA, &brojB, &brojAB);

            if(brojO >= MIN_BROJ_KRVI && brojO <= MAX_BROJ_KRVI)
            {
                if(brojA >= MIN_BROJ_KRVI && brojA <= MAX_BROJ_KRVI)
                {
                    if(brojB >= MIN_BROJ_KRVI && brojB <= MAX_BROJ_KRVI)
                    {
                        if(brojAB >= MIN_BROJ_KRVI && brojAB <= MAX_BROJ_KRVI)
                        {
                            uspesno = true;
                        }
                    }
                }
            }
            if(uspesno)
            {
                uspesno = (brojO + brojA + brojB + brojAB <= MAX_BROJ_KRVI) ? true : false;
            }
        }

        if(!uspesno)
        {
            cout << "Pogresan unos, pokusaj opet: ";
            getline(cin, str);
        }
        else
        {
            break;
        }
    }

    /// Uneti za svakog pacijenta krvnu grupu i broj potrebnih jedinica. Primer A 2
    Pacijent pacijenti[brojPacijenata];

    for(unsigned short int i = 0; i < brojPacijenata; i++)
    {
        pacijenti[i].jedO = 0;
        pacijenti[i].jedA = 0;
        pacijenti[i].jedB = 0;
        pacijenti[i].jedAB = 0;
    }

    for(unsigned short int i = 0; i < brojPacijenata; i++)
    {
        getline(cin, str);
        unsigned int tempJedinica;
        char tempGrupa[3];
        while(true)
        {
            bool uspesno = false;

            char counter = 1;
            size_t found = -1;
            while(true)
            {
                found  = str.find(' ', found + 1);
                if(found != string::npos)
                {
                    counter++;
                }
                else
                {
                    break;
                }
            }

            if(counter == 2)
            {
                sscanf(str.c_str(), "%s %u", tempGrupa, &tempJedinica);

                if(!strcmp("O", tempGrupa) || !strcmp("A", tempGrupa) || !strcmp("B", tempGrupa) || !strcmp("AB", tempGrupa))
                {
                    if(tempJedinica >= MIN_BROJ_KRVI && tempJedinica <= MAX_BROJ_KRVI)
                    {
                        uspesno = true;
                    }
                }
            }

            if(!uspesno)
            {
                cout << "Pogresan unos, pokusaj opet: ";
                getline(cin, str);
            }
            else
            {
                break;
            }
        }
        pacijenti[i].jedinica = tempJedinica;

        pacijenti[i].grupa = (!strcmp("O", tempGrupa)) ? O : (!strcmp("A", tempGrupa)) ? A : (!strcmp("B", tempGrupa)) ? B : AB ;
    }

    /// Izracunaj mogucnosti
    /// O - moze samo O
    /// A - A/O
    /// B - B/O
    /// AB - sve

    unsigned int potrebnihO  = 0;
    unsigned int potrebnihA  = 0;
    unsigned int potrebnihB  = 0;
    unsigned int potrebnihAB = 0;

    bool uspesno = true;

    for(unsigned short i = 0; i < brojPacijenata; i++)
    {
        unsigned int potrebno = pacijenti[i].jedinica;

        switch(pacijenti[i].grupa)
        {

        case O:
            if(potrebnihO + pacijenti[i].jedinica <= brojO)
            {
                potrebnihO += pacijenti[i].jedinica;
                pacijenti[i].jedO = pacijenti[i].jedinica;
            }
            else
            {
                uspesno = false;
            }
            break;

        case A:
            if(potrebnihA + potrebno <= brojA)
            {
                potrebnihA += potrebno;
                pacijenti[i].jedA = potrebno;
            }
            else if((potrebnihO + (potrebno = brojA - potrebnihA)) <= brojO)
            {
                potrebnihA += potrebno;
                pacijenti[i].jedA = potrebno;

                potrebnihO += pacijenti[i].jedinica - potrebno;
                pacijenti[i].jedO = pacijenti[i].jedinica - potrebno;
            }
            else
            {
                uspesno = false;
            }
            break;

        case B:
            if(potrebnihB + potrebno <= brojB)
            {
                potrebnihB += potrebno;
                pacijenti[i].jedB = potrebno;
            }
            else if((potrebnihO + (potrebno = brojB - potrebnihB)) <= brojO)
            {
                potrebnihB += potrebno;
                pacijenti[i].jedB = potrebno;

                potrebnihO += pacijenti[i].jedinica - potrebno;
                pacijenti[i].jedO = pacijenti[i].jedinica - potrebno;
            }
            else
            {
                uspesno = false;
            }
            break;

        default:
            break;

        }

        if(!uspesno)
        {
            break;
        }
    }

    for(unsigned short i = 0; i < brojPacijenata; i++)
    {
        if(pacijenti[i].grupa == AB)
        {
            potrebnihAB += pacijenti[i].jedinica;
        }
    }

    unsigned int ukupniBroj = brojO + brojA + brojB + brojAB;
    unsigned int ukupnoPotr = potrebnihO + potrebnihA + potrebnihB + potrebnihAB;
    if(ukupniBroj - ukupnoPotr < 0)
    {
        uspesno = false;
    }

    /// Ispisi: moguce/nemoguce
    /// Ako je moguce ispisi broj i  vrstu jedinica krvi dodeljenu pacijetnu

    if(!uspesno)
    {
        cout << "nemoguce";
    }
    else
    {
        cout << "moguce" << endl;

        potrebnihAB = 0;

        for(unsigned short int i = 0; i < brojPacijenata; i++)
        {

            if(pacijenti[i].grupa == AB)
            {
                unsigned int potrebno = pacijenti[i].jedinica;
                if(potrebno <= brojAB - potrebnihAB)
                {
                    pacijenti[i].jedAB = potrebno;
                }
                else
                {
                    pacijenti[i].jedAB = brojAB - potrebnihAB;
                    potrebno = potrebno - pacijenti[i].jedAB;
                    if(potrebno)
                    {
                        pacijenti[i].jedO = brojO - potrebnihO;
                        potrebnihO += pacijenti[i].jedO;
                        potrebno = potrebno - pacijenti[i].jedO;

                        if(potrebno)
                        {
                            pacijenti[i].jedA = brojA - potrebnihA;
                            potrebnihA += pacijenti[i].jedA;
                            potrebno = potrebno - pacijenti[i].jedA;

                            if(potrebno)
                            {
                                pacijenti[i].jedB = brojB - potrebnihB;
                                potrebnihB += pacijenti[i].jedB;
                            }
                        }
                    }
                }
            }

            cout << pacijenti[i].jedO << " " << pacijenti[i].jedA << " " << pacijenti[i].jedB << " " << pacijenti[i].jedAB << endl;
        }
    }

    return 0;
}